/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.property.tables;

import filenet.vw.api.VWFieldDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.property.resources.VWResource;
import filenet.vw.toolkit.design.property.tables.VWExpressionCellEditor;
import filenet.vw.toolkit.design.property.tables.VWFieldTableModel;
import filenet.vw.toolkit.utils.IVWPropertyData;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.table.VWLabelListCellRenderer;
import filenet.vw.toolkit.utils.uicontrols.expressionbuilder.VWArrayEditorTableModel;
import filenet.vw.toolkit.utils.uicontrols.expressionbuilder.VWExpressionArrayBuilderDialog;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyListener;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;

public class VWExpressionCellEditorForFieldTable
extends VWExpressionCellEditor
implements TableCellEditor,
ActionListener,
KeyListener {
    protected VWExpressionArrayBuilderDialog m_expressionArrayDialog = null;
    protected JComboBox m_booleanComboBox = null;
    protected boolean m_bIsArray = false;
    protected boolean m_bIsBoolean = false;

    public VWExpressionCellEditorForFieldTable(IVWPropertyData propertyData) {
        super(propertyData);
    }

    public VWExpressionCellEditorForFieldTable(IVWPropertyData propertyData, int orientation) {
        super(propertyData, orientation);
    }

    public VWExpressionCellEditorForFieldTable(IVWPropertyData propertyData, boolean bIsBoolean) {
        super(propertyData);
        this.m_bIsBoolean = bIsBoolean;
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        Component component = super.getTableCellEditorComponent(table, value, isSelected, row, column);
        component.setComponentOrientation(table.getComponentOrientation());
        if (table.getModel() instanceof VWFieldTableModel) {
            VWFieldTableModel tableModel = (VWFieldTableModel)table.getModel();
            VWFieldDefinition fieldDef = tableModel.getItemAt(row);
            if (fieldDef != null) {
                this.m_bIsArray = fieldDef.isArray();
                this.m_bIsBoolean = fieldDef.getFieldType() == 4;
            } else {
                String type = tableModel.getCurrentFieldType();
                this.m_bIsArray = tableModel.isArrayType(type);
                this.m_bIsBoolean = tableModel.getFieldType(type) == 4;
            }
        } else {
            this.m_bIsArray = false;
        }
        if (this.m_bIsArray) {
            this.m_button.setVisible(true);
        } else {
            this.m_button.setVisible(false);
            if (this.m_bIsBoolean && this.m_booleanComboBox == null) {
                this.m_booleanComboBox = new JComboBox();
                this.m_booleanComboBox.addItem(VWResource.s_true);
                this.m_booleanComboBox.addItem(VWResource.s_false);
                this.m_booleanComboBox.setSelectedIndex(VWStringUtils.compare(value.toString(), "true") == 0 ? 0 : 1);
                this.m_booleanComboBox.setRenderer(new VWLabelListCellRenderer());
                this.m_booleanComboBox.setComponentOrientation(table.getComponentOrientation());
            }
        }
        return !this.m_bIsArray && this.m_bIsBoolean ? this.m_booleanComboBox : component;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void actionPerformed(ActionEvent event) {
        String fieldName = "";
        int fieldType = 2;
        if (this.m_bButtonClickedBeforeReady) {
            this.m_bButtonClickedBeforeReady = false;
            return;
        }
        if (this.m_editingWithDialog) {
            return;
        }
        if (this.m_table.getModel() instanceof VWFieldTableModel) {
            VWFieldTableModel tableModel = (VWFieldTableModel)this.m_table.getModel();
            VWFieldDefinition fieldDef = tableModel.getItemAt(this.m_row);
            if (fieldDef != null) {
                fieldName = fieldDef.getName();
                fieldType = fieldDef.getFieldType();
                this.m_bIsArray = fieldDef.isArray();
            } else {
                fieldName = "";
                String type = tableModel.getCurrentFieldType();
                fieldType = tableModel.getFieldType(type);
                this.m_bIsArray = tableModel.isArrayType(type);
            }
        } else if (this.m_table.getModel() instanceof VWArrayEditorTableModel) {
            this.m_bIsArray = false;
        }
        if (!this.m_bIsArray) return;
        this.updateCurrentValue();
        this.m_editingWithDialog = true;
        this.m_textField.setText(VWResource.s_editing);
        this.m_textField.setEditable(false);
        try {
            block15: {
                try {
                    Container parent = this.getParentContainer();
                    if (parent instanceof Frame) {
                        this.m_expressionArrayDialog = new VWExpressionArrayBuilderDialog((Frame)parent, this.m_propertyData, this.m_currentValue, fieldName, fieldType);
                    } else if (parent instanceof Dialog) {
                        this.m_expressionArrayDialog = new VWExpressionArrayBuilderDialog((Dialog)parent, this.m_propertyData, this.m_currentValue, fieldName, fieldType);
                    }
                    if (this.m_expressionArrayDialog == null) break block15;
                    this.m_expressionArrayDialog.init();
                    this.m_expressionArrayDialog.setVisible(true);
                    this.updateCurrentValue();
                    this.stopCellEditing();
                }
                catch (Exception ex) {
                    VWDebug.logException(ex);
                    Object var8_9 = null;
                    this.m_textField.setText(this.m_currentValue);
                    this.m_textField.setEditable(true);
                    this.m_textField.requestFocus();
                    this.m_editingWithDialog = false;
                    return;
                }
            }
            Object var8_8 = null;
            this.m_textField.setText(this.m_currentValue);
            this.m_textField.setEditable(true);
            this.m_textField.requestFocus();
            this.m_editingWithDialog = false;
            return;
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            this.m_textField.setText(this.m_currentValue);
            this.m_textField.setEditable(true);
            this.m_textField.requestFocus();
            this.m_editingWithDialog = false;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int updateCurrentValue() {
        int result = 1;
        if (!this.m_bIsArray) {
            if (!this.m_bIsBoolean) {
                result = super.updateCurrentValue();
            } else {
                this.m_currentValue = VWStringUtils.compare(this.m_booleanComboBox.getSelectedItem().toString(), VWResource.s_true) == 0 ? "true" : "false";
                result = 2;
            }
        } else {
            try {
                block13: {
                    try {
                        if (this.m_bUpdatingValue) {
                            result = 0;
                            break block13;
                        }
                        if (this.m_editingWithDialog) {
                            if (this.m_expressionArrayDialog != null) {
                                this.m_bUpdatingValue = true;
                                if (this.m_expressionArrayDialog.getDialogResult() == 0) {
                                    this.m_currentValue = this.m_expressionArrayDialog.getExpressionString();
                                    result = 2;
                                } else {
                                    result = 1;
                                }
                            }
                            break block13;
                        }
                        this.m_currentValue = this.m_textField.getText();
                        result = 2;
                    }
                    catch (Exception ex) {
                        VWDebug.logException(ex);
                        Object var4_3 = null;
                        this.m_bUpdatingValue = false;
                    }
                }
                Object var4_2 = null;
                this.m_bUpdatingValue = false;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                this.m_bUpdatingValue = false;
                throw throwable;
            }
        }
        return result;
    }
}

